FNAME "mob_obj_graphics_ii.bin"
CPU Z80
ORG $8000
include "Coleco_Include.asm"
SPRITE_NAME:		EQU	7100h	;Pointer to sprite attributes name table
	; max 32 sprites * 4 bytes each = 128 bytes
SPRITE_ORDER:		EQU	7190h	;Pointer to sprite order table
	; max 32 sprites
WORK_BUFFER:		EQU	8006h	;6400h	;Pointer to graphics work area
	; up to around 300h max usage
CONTROLLER_BUFFER:	EQU	72E0h	;Pointer to hand controller input area
	;12 bytes
TIMER_TABLE:		EQU	77ACh	;Pointer to timers table
	;16 timers
TIMER_DATA_BLOCK:	EQU	77DCh	;Pointer to timers table for long timers
ACTIVATE:			EQU 1FF7h
STATUS:				EQU 6300h
STATUSFM:			EQU 6300h
STATUSX:			EQU 6301h
STATUSY:			EQU 6303h
STATUSNG:			EQU	6305h
OLD_SCREEN:			EQU 7400h
FLAGS:				EQU	3
FRM:				EQU	4
YDISP:				EQU	0
XDISP:				EQU	1
YP_BK:				EQU	18
XP_BK:				EQU	17
PX_TO_PTRN_POS:		EQU	07E8H
GET_BKGRND:			EQU	0898H
PM2:				EQU	0AE0H
MODE:				EQU 1
NEW_GEN:			EQU	5000h
FIRST_GEN_NAME:		EQU	40h
DefPatternTable:	EQU	0h
DefNameTable:		EQU	1800h
DefSprAttrTable:	EQU	1b00h
DefColorTable:		EQU	2000h
DefSprPatTable:		EQU	3800h
;
; Tables
	DB	055h,0aah	;Magic number -- means skip intro, reverse for traditional
        ;DB	0aah,055h	;Magic number -- means show 10 sec title screen
	DW	7100h		;SPRITE_NAME	;Pointer to sprite name table
	DW	7190h		;SPRITE_ORDER	;Pointer to sprite order table
	DW	9000h		;WORK_BUFFER	;Pointer to graphics tempory work area
	DW	77ACh		;CONTROLLER_BUFFER	;Pointer to hand controler input area
	DW	MAIN_PROG	;Entry point to game
; Vectors
	JP	RST08		;Restart 8
	JP	RST10		;Restart 10h
	JP	RST18		;Restart 18h
	JP	RST20		;Restart 20h
	JP	RST28		;Restart 28h
	JP	RST30		;Restart 30h
	JP	MASK_INT	;Maskable interrupt (used by spinner)
	JP	VDPINT		;NMI interrupt (used by VDP 60 times per second)
; Title screen name
	DB	'MOBILE OBJECT',1eh,1fh
	DB	'/TELEMETRY'
	DB	'/2019'
	;1dh is copyright symbol
	;1eh,1fh is trade mark symbol
;Pointer to DCB (Device Control Block)
DEV_ID:	DB	8	;Default DEVICE_ID but check for B from boot block

; Implementation of vectors
	RST08:
	RST10:
	RST18:
	RST20:
	RST28:
	RST30:
	RET
MASK_INT:
	RETI	;Used with spinner: steering wheel, 
		;super action, roller controller
VDPINT:
	PUSH	AF
	PUSH	BC
	PUSH	DE
	PUSH	HL
	PUSH	IX
	PUSH	IY
	EX	AF,AF'
	PUSH	AF
	EXX
	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD		A,(SECOND_TIMER)
    CALL	TEST_SIGNAL
	OR		A
	JR		Z,.6
	LD 		A,(STATUSFM)
	INC		A
	CP		2
	JR		NZ,.1
	LD 		A,0
	JR		.3
.1:
	CP		130
	JR		NZ,.3
	LD 		A,128
.3:
	LD 		(STATUSFM),A
.6:
	LD 		A,(STATUSX)
	DEC 	A
	LD  	(STATUSX),A
;	LD 		A,(STATUSY)
;	INC 	A
;	LD  	(STATUSY),A
	LD 		IX,MOB
	LD 		HL,GRAPHICS
	LD 		B,MODE
	CALL 	PUTMOBILE2
	CALL	TIME_MGR
;Now restore everything
	POP		HL
	POP		DE
	POP		BC
	EXX
	POP		AF
	EX		AF,AF'
	POP		IY
	POP		IX
	POP		HL
	POP		DE
	POP		BC
;
	IN		A,(0BFh)	;Side effect allows another NMI to happen
;
	POP		AF
;
	RETN	;Non maskable interrupt used for:
MAIN_PROG:
	IM 		1
	CALL	SETSCREEN2
	CALL	CLEAR_VRAM
	CALL	LOAD_ASCII
	CALL	COPY_ASCII3
	; Initialize Timers
	LD		HL,TIMER_TABLE
	LD		DE,TIMER_DATA_BLOCK
	CALL	INIT_TIMER
;--------------------------------------------------------
; Enable timers
	CALL	CREATE_TIMERS
	LD 		HL,0060h
	LD  	(STATUSX),HL
	LD  	(STATUSY),HL
;
	LD      A,013h
	LD      DE,1800h
	LD      HL,2000h
	CALL    FILL_VRAM
;
	LD      HL,MOB
	SCF     
	CALL    ACTIVATE
;
	LD      BC,01e0h
	CALL    WRITE_REGISTER
LOOP:
	JP      LOOP
;--------------------------------------------------------
;
; PUTMOBILE version GRAPHICS MODE II
;
PUTMOBILE2:
	LD		IY,(8006h)
	SET		7,B
	LD		(IY+FLAGS),B
	PUSH	HL
	LD		H,(IX+3)
	LD		L,(IX+2)
	LD		A,(HL)
	LD		(IY+FRM),A
	XOR		80h
	LD		(HL),A
	INC		HL
	LD		E,(HL)
	LD		A,E
	AND		7
	NEG
	ADD		A, 8
	LD		(IY+XDISP),A
	INC		HL
	LD		D,(HL)
	CALL	PX_TO_PTRN_POS
	LD		(IY+XP_BK),E
	INC		HL
	LD		E,(HL)
	LD		A,E
	AND		7
	LD		(IY+YDISP),A
	INC		HL
	LD		D,(HL)
	CALL	PX_TO_PTRN_POS
	LD		(IY+YP_BK),E
	LD		HL,(8006h)
	LD		DE,YP_BK+1
	ADD		HL,DE
	LD		D,(IY+YP_BK)
	LD		E,(IY+XP_BK)
	LD		BC,0303h
	PUSH	IX
	CALL	GET_BKGRND
	POP		IX
	JP		PM2			; Call rest of OS PUT_MOBILE routine
;--------------------------------------------------------
CREATE_TIMERS:
;    LD		HL,(AMERICA)
	LD 		HL,4
	LD		H,0
	LD		A,1
	CALL	REQUEST_SIGNAL
	LD		(SECOND_TIMER),A
	RET
SECOND_TIMER:
	DS	1
;--------------------------------------------------------
CLEAR_VRAM:
	XOR	A
	LD	DE, $4000
	LD	HL, $0000
	JP	FILL_VRAM
;--------------------------------------------------------
COPY_ASCII3:
;Copies ASCII from 1st pattern generator to 2nd and 3rd
	LD		BC,1024        ;Count
	LD		DE,$0000       ;Source read
	LD		HL,$2C00       ;Destination write
	CALL	READ_VRAM
	LD      DE,$0800       ;Destination
	LD		HL,$2C00       ;Source
	LD		BC,1024        ;Count
	CALL	WRITE_VRAM
	LD      DE,$1000       ;Destination
	LD		HL,$2C00       ;Source
	LD		BC,1024        ;Count
	CALL	WRITE_VRAM
	RET
;--------------------------------------------------------
; Setup Graphic Mode 2 - 16K VRAM, Screen is OFF, Interrupts are disabled, 8x8 sprites, no sprite magnification
SETSCREEN2:
    LD 		BC,0002h		;Reg 0: Text Mode
    CALL 	WRITE_REGISTER
    LD 		BC,0206h		;Reg 2: Name table 1800h
    CALL 	WRITE_REGISTER
    LD 		BC,03FFh		;Reg 3: Color table 2000h
    CALL 	WRITE_REGISTER
    LD 		BC,0403h		;Reg 4: Pattern Generator table 0000h
    CALL 	WRITE_REGISTER
    LD 		BC,0536h		;Reg 5: Sprite Attribute table 1B00h
    CALL 	WRITE_REGISTER
    LD 		BC,0607h		;Reg 6: Sprite Pattern table 3800h
    CALL 	WRITE_REGISTER
    LD 		BC,07B1h		;Reg 7: Backdrop color black, Foreground color white
   	JP 		WRITE_REGISTER
;--------------------------------------------------------
MOB:
	DW	GRAPHICS
	DW	STATUS
	DW	OLD_SCREEN
	DW	FIRST_GEN_NAME
GRAPHICS:
	DB	01h
	DB	08h
	DW	NEW_GEN
	DW	GENERATORS
	DW	FRAME0
	DW	FRAME1
;	DW	FRAME2
FRAME0:
	DB	00h,01h,02h,03h,010h
FRAME1:
	DB	04h,05h,06h,07h,010h
;FRAME2:
;	DB	08h,09h,0ah,0bh,0F0h
GENERATORS:
;// FRAME 0 ////////////////////////////
;   // upper left
;    DB 00000000b,00000111b,00011111b,00111111b,00111111b,01111110b,01111100b,01111000b   
 ;  // lower right
;    DB 01111100b,01111110b,00111111b,00111111b,00011111b,00000111b,00000000b,00000000b
;   // upper right
;    DB 00000000b,11000000b,11000000b,10000000b,00000000b,00000000b,00000000b,00000000b
;   // lower right
;    DB 00000000b,00000000b,00000000b,10000000b,11000000b,11000000b,00000000b,00000000b
;// FRAME 1 ////////////////////////////
;   // upper left
;    DB 00000000b,00000111b,00011111b,00111111b,00111111b,01111111b,01111111b,01111000b
;   // lower left
;    DB 01111111b,01111111b,00111111b,00111111b,00011111b,00000111b,00000000b,00000000b
;   // upper right
;    DB 00000000b,11000000b,11110000b,11111000b,11111000b,11100000b,00000000b,00000000b
;   // lower right
;    DB 00000000b,11100000b,11111000b,11111000b,11110000b,11000000b,00000000b,00000000
;// FRAME 2 ////////////////////////////
;   // upper left
;    DB 00000000b,00000111b,00011111b,00111111b,00111111b,01111111b,01111111b,01111111b
;   // lower left
;    DB 01111111b,01111111b,00111111b,00111111b,00011111b,00000111b,00000000b,00000000b
;   // upper right
;    DB 00000000b,11000000b,11110000b,11111000b,11111000b,11111100b,11111100b,11111100b
;   // lower right
;    DB 11111100b,11111100b,11111000b,11111000b,11110000b,11000000b,00000000b,00000000b
;
; Sprite sprite_1 pattern 1
;   db 000,000,000,000,001,003,063,127
;   db 247,001,007,001,000,000,000,000
;   db 000,062,124,248,240,240,248,240
;   db 128,128,000,000,000,000,000,000
; Sprite sprite_1 pattern 1
;   db 000,000,000,000,000,000,063,127
;   db 247,001,007,001,000,000,000,000
;   db 000,000,000,000,000,000,254,252
;   db 248,192,000,000,000,000,000,000
; Sprite sprite_1 pattern 1
;   db 000,000,000,000,000,000,063,127
;   db 247,001,007,001,000,000,000,000
;   db 000,000,000,000,000,000,248,240
;   db 240,248,248,124,062,000,000,000
;black bird
; Sprite sprite_1 pattern 1
   db 000,000,000,000,014,062,127,227
   db 223,188,132,128,000,000,000,000
   db 000,000,000,000,000,096,240,252
   db 255,126,060,028,012,004,000,000
; Sprite sprite_1 pattern 1
   db 128,128,192,248,254,126,063,003
   db 031,060,004,000,000,000,000,000
   db 001,001,003,031,127,254,252,248
   db 254,031,030,002,000,000,000,000